#include <cstdio>
#include <iostream>
#include <string>
#include <vector>
#include <algorithm>
#include <cmath>
#include <cassert>
#include <memory.h>
#include <queue>
#include <deque>
#include <stack>
#include <list>
#include <map>
#include <set>
#include <functional>
#include <cstring>
#include <ctime>

using namespace std;

#define all(a) a.begin(), a.end()
#define mp make_pair

typedef long long li;
typedef long double ld;
typedef pair<int, int> pi;
typedef vector<int> vi;

#define FILENAME ""

void solve();
int main() {
#ifdef YA
	string s = FILENAME;
	//assert(!s.empty());
	clock_t start = clock();
	freopen("input.txt", "r", stdin);
	//freopen("output.txt", "w", stdout);
#else
	//freopen(FILENAME ".in", "r", stdin);
	//freopen(FILENAME ".out", "w", stdout);
	//freopen("input.txt", "r", stdin);
	//freopen("output.txt", "w", stdout);
#endif
	cout.sync_with_stdio(0);
	cin.tie(0);
	cout.precision(15);
	cout << fixed;

	int t = 1;
	//cin >> t;
	while(t--) {
		solve();
	}
#ifdef YA
	cout << "\n\n" << (clock() - start) / 1.0 / CLOCKS_PER_SEC << "\n\n";
#endif
	return 0;
}


//#define int li

struct Edge {
	int from, to;
	int cap, cost, flow;
};

vector<Edge> edges;
vector<int> g[111];

void add_edge(int from, int to, int cap, int cost) {
	Edge e1 = {from, to, cap, cost, 0};
	g[from].push_back(edges.size());
	edges.push_back(e1);
	Edge e2 = {to, from, 0, -cost, 0};
	g[to].push_back(edges.size());
	edges.push_back(e2);
}

const int INF = 1e9;

int mincost(int n, int s, int t) {
	int flow = 0;
	int cost = 0;
	while(true) {
		
		vector<int> dist(n, INF);
		vector<int> par(n, -1); // edge id;
		dist[s] = 0;
		bool changed = true;
		while(changed) {
			changed = false;
			for(int i = 0; i < edges.size(); ++i) {
				Edge& e = edges[i];
				if(e.cap == e.flow)
					continue;
				if(dist[e.from] == INF)
					continue;
				if(dist[e.to] > dist[e.from] + e.cost) {
					dist[e.to] = dist[e.from] + e.cost;
					par[e.to] = i;
					changed = true;
				}
			}
		}

		if(dist[t] >= 0)
			break;

		int end = t;
		while(end != s) {
			int id = par[end];
			edges[id].flow += 1;
			edges[id ^ 1].flow -= 1;
			end = edges[id].from;
		}

		cost += dist[t];
		flow += 1;

	}

	return flow;

}

void dfs(int v, int s, int t) {
	if(v == t)
		return;
	if(v != s)
		cout << v + 1<< " ";
	for(int i = 0; i < g[v].size(); ++i) {
		Edge& e = edges[g[v][i]];
		if(e.flow > 0) {
			--e.flow;
			dfs(e.to, s, t);
			return;
		}
	}
}

void solve() {
	int n;
	cin >> n;
	int s = n, t = n + 1;
	for(int i = 0; i < n; ++i) {

		int k;
		cin >> k;
		for(int j = 0; j < k; ++j) {
			int z;
			cin >> z;
			--z;
			add_edge(i, z, 1, -100000);
			add_edge(i, z, 100000, 0);
		}

		add_edge(s, i, 1000000000, 1);
		add_edge(i, t, 1000000000, 0); 
	}

	int flow = mincost(n + 2, s, t);

	cout << flow << endl;

	for(int i = 0; i < flow; ++i) {
		dfs(s, s, t);
		cout << "\n";
	}
}